#include <p30fxxxx.h>
#include <ports.h>

#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__)|| \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__)|| \
    defined(__dsPIC30F6014__)

/*******************************************************************
* Function Name     : ConfigINT3
* Description       : Enables external interrupt on pin INT3
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Return Value      : None
********************************************************************/

void ConfigINT3(unsigned int config)
{
    IFS2bits.INT3IF = 0;                       /* clear the interrupt flag */
    IPC9bits.INT3IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT3EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC2bits.INT3IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT3 */

#endif
